import json

with open('datasets/vqa_data/vqa_results.json', 'r') as f:
    results = json.load(f)

num = 0
for result in results:
    if max(result["result"]) >= 0.6 and max(result["result"]) != min(result["result"]):
        max_result = max(result["result"])
        min_result = min(result["result"])
        max_index = result["result"].index(max_result)
        min_index = result["result"].index(min_result)
        with open('datasets/preference_data.json', "a") as f:
            json.dump({"id": result["id"],
                        "caption": result["caption"],
                        "win_image": 'datasets/images/' + result["id"] + '/' + str(max_index) + '.png',
                        "lose_image": 'datasets/images/' + result["id"] + '/' + str(min_index) + '.png',
                        "win_image_score": max_result,
                        "lose_image_score": min_result
                        }, f, ensure_ascii=False, indent=4)
            f.write(',\n')